'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Report_Activate()
    On Error Resume Next
    
    Dim Text As String
    
    Text = Me.Controls.Item("Rechnung_Rechnungsdaten").Controls.Item("Re_Nr")
    
    While InStr(Text, "\")
        Text = Left(Text, InStr(Text, "\") - 1) & "-" & Mid(Text, InStr(Text, "\") + 1)
    Wend
    While InStr(Text, "/")
        Text = Left(Text, InStr(Text, "/") - 1) & "-" & Mid(Text, InStr(Text, "/") + 1)
    Wend
    While InStr(Text, ":")
        Text = Left(Text, InStr(Text, ":") - 1) & "=" & Mid(Text, InStr(Text, ":") + 1)
    Wend
    While InStr(Text, "*")
        Text = Left(Text, InStr(Text, "*") - 1) & "_" & Mid(Text, InStr(Text, "*") + 1)
    Wend
    While InStr(Text, "?")
        Text = Left(Text, InStr(Text, "?") - 1) & "_" & Mid(Text, InStr(Text, "?") + 1)
    Wend
    While InStr(Text, """")
        Text = Left(Text, InStr(Text, """") - 1) & "'" & Mid(Text, InStr(Text, """") + 1)
    Wend
    While InStr(Text, "<")
        Text = Left(Text, InStr(Text, "<") - 1) & "_" & Mid(Text, InStr(Text, "<") + 1)
    Wend
    While InStr(Text, ">")
        Text = Left(Text, InStr(Text, ">") - 1) & "_" & Mid(Text, InStr(Text, ">") + 1)
    Wend
    While InStr(Text, "|")
        Text = Left(Text, InStr(Text, "|") - 1) & "_" & Mid(Text, InStr(Text, "|") + 1)
    Wend
    
    Me.Caption = "Stornobeleg [" & Text & "]"
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
    
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    
    'berschrift fr Dauer einstellen
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std"
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min"
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
    End Select

End Sub
